/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.server;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.ui.internal.Messages;

public class DeleteServerDialog
extends MessageDialog {
    protected List<IServer> servers;

    public DeleteServerDialog(Shell parentShell, List<IServer> servers) {
        super(parentShell, Messages.deleteServerDialogTitle, null, DeleteServerDialog.getMessage(servers), DeleteServerDialog.getImage(servers), new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.servers = servers;
    }

    private static int getImage(List<IServer> servers) {
        for (IServer iServer : servers) {
            if (iServer.getBoundProjects().isEmpty()) continue;
            return 4;
        }
        return 3;
    }

    private static String getMessage(List<IServer> servers) {
        StringBuilder sb = new StringBuilder();
        if (servers.size() == 1) {
            sb.append(NLS.bind((String)Messages.deleteServerDialogMessage, (Object)servers.get(0).getName()));
        } else {
            sb.append(NLS.bind((String)Messages.deleteServerDialogMessageMany, (Object)Integer.toString(servers.size())));
        }
        int boundCount = 0;
        for (IServer iServer : servers) {
            boundCount += iServer.getBoundProjects().size();
        }
        if (boundCount > 0) {
            sb.append("\n").append(NLS.bind((String)Messages.deleteServerDialogBoundProject, (Object)boundCount));
        }
        return sb.toString();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0 && !this.servers.isEmpty()) {
            Job job = new Job(Messages.deleteServerTask){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        for (IServer server : DeleteServerDialog.this.servers) {
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            server.delete();
                        }
                    }
                    catch (Exception e) {
                        return new Status(4, "org.sonarlint.eclipse.ui", 0, e.getMessage(), (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(40);
            job.schedule();
        }
        super.buttonPressed(buttonId);
    }
}

